// material review
// m.miller 04.22.23

#version 3.8; 
global_settings {    
    max_trace_level 7
    ambient_light <.013,.01,.01> * 10                  
}                        

// -----------------------------------------------------------------------------------------
//                      L I G H T S
//------------------------------------------------------------------------------------------
#declare light_left =
light_source {
    <0,0,0> 
    #declare light_color = color red .05 green .05 blue .05 ;                      
    light_color * 5                  
    area_light
    <50, 0, 0> <0, 0, 50>         
    4, 4                          
    adaptive 0                    
    jitter                        
    circular                      
    orient                     
    fade_distance 400
    fade_power 2     
    translate <-200,200,-50>
}   
light_left

#declare light_right =
light_source {
    <0,0,0> 
    #declare light_color = color red .05 green .05 blue .05 ;                      
    light_color * 5                  
    area_light
    <50, 0, 0> <0, 0, 50>         
    4, 4                          
    adaptive 0                    
    jitter                        
    circular                      
    orient                     
    fade_distance 400
    fade_power 2     
    translate <200,200,-200>
}   
light_right


    
// -----------------------------------------------------------------------------------------
//                      S K Y
//------------------------------------------------------------------------------------------ 
background { rgb <0.12, 0.11, 0.1> * .2 } 
#include "sky/sky.inc"
object { bg_sphere (<2000,2000,2000>, <0,100,0>, 250) scale <-1,1,1> }



       
// -----------------------------------------------------------------------------------------
//                      S T A G E 
//------------------------------------------------------------------------------------------  
#include "stage/stage.inc"  
object { stage }
//object { stage scale <1,1,-1>}


// -----------------------------------------------------------------------------------------
//                      S A M P L E S
//------------------------------------------------------------------------------------------ 
#include "default_materials.inc"

// M_metal_lead
// M_metal_steel
// M_metal_gold
// M_spool
// M_bleaker_black_plastic
// M_panel_gray
// M_galvanize
// M_metal_steel_old
// M_steel_aged   
// M_steel_pitted
// M_steel_oxidized
// M_gold_resin
// M_metal_chrome
// M_old_copper
// M_steel_aged_2
// M_brass_aged
//
// M_old_trim_2
// M_old_trim
//
//
//
// M_black_rubber
// M_black_gloss
//
// M_red_gloss
// M_red_rubber

#declare sampleCount = 19 ;
#declare _mat_array = array[sampleCount] ;
#declare _mat_array[0] =    material {M_metal_lead};
#declare _mat_array[1] =    material {M_metal_steel};
#declare _mat_array[2] =    material {M_metal_gold};
#declare _mat_array[3] =    material {M_spool};
#declare _mat_array[4] =    material {M_bleaker_black_plastic};
#declare _mat_array[5] =    material {M_panel_gray};
#declare _mat_array[6] =    material {M_galvanize scale .1};  
#declare _mat_array[7] =    material {M_metal_steel_old};
#declare _mat_array[8] =    material {M_steel_aged scale .5};
#declare _mat_array[9] =    material {M_steel_pitted};
#declare _mat_array[10] =   material {M_steel_pitted scale <.1,.1,.1>};
#declare _mat_array[11] =   material {M_steel_oxidized };
#declare _mat_array[12] =   material {M_steel_oxidized scale <.1,.1,.1>};
#declare _mat_array[13] =   material {M_steel_black_rough scale <.01,.01,.01>};
#declare _mat_array[14] =   material {M_steel_aged_2 scale <.25,.25,.25>};
#declare _mat_array[15] =   material {M_old_trim_2 scale <.1,.1,.1>};
#declare _mat_array[16] =   material {M_old_trim scale <.1,.1,.1>};
#declare _mat_array[17] =   material {M_brass_aged scale <.11,.11,.11>};
#declare _mat_array[18] =   material {M_metal_chrome };

#declare gap = 3;
#declare sample = sphere {<0,0,0> 1 translate <0,1,0> }
#for (i,0, sampleCount-1)
    object { sample material {_mat_array[i]} translate <i*gap,0,0>}
#end


// -----------------------------------------------------------------------------------------
//                      C A M E R A - look at sample #
//------------------------------------------------------------------------------------------ 

#declare _look_at_sample = 12 ;

#declare cam_x = (_look_at_sample)*gap ;
#declare cam_iso =
    camera {
        up <0, 1, 0>  
        angle 30    
        location <cam_x,1,-10> 
        look_at <cam_x,1,30>
    } 
    

camera {cam_iso}